(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     23333,        635]*)
(*NotebookOutlinePosition[     24832,        678]*)
(*  CellTagsIndexPosition[     24788,        674]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Integrales de l\[IAcute]nea. Campos conservativos", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada
\
\>", "Author",
  TextAlignment->Right,
  FontSize->12],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell[TextData[{
  "Como esta es la tercera pr\[AAcute]ctica de este curso debes volver a leer \
con atenci\[OAcute]n las normas para entregar los trabajos de \
pr\[AAcute]cticas que est\[AAcute]n escritas en la introducci\[OAcute]n de la \
pr\[AAcute]ctica primera. As\[IAcute]mismo, te recuerdo que el trabajo de pr\
\[AAcute]cticas debe ser un trabajo personal. Debes ser capaz de explicar con \
detalle el trabajo que has hecho en cualquiera de las pr\[AAcute]cticas que \
hayas entregado. No debes concederte la debilidad de copiar el trabajo \
realizado por otro compa\[NTilde]ero. Los intentos de disfrazar el \
c\[OAcute]digo cambiando nombres de variables, modificando los comentarios o \
alterando el orden son muy f\[AAcute]ciles de descubrir. En el caso de que \
las pr\[AAcute]cticas de dos alumnos se \"parezcan demasiado\" ambas ser\
\[AAcute]n calificadas ",
  StyleBox["como se merecen",
    FontSlant->"Italic"],
  ".\nCada pr\[AAcute]ctica se califica de 0 a 10. En la calificaci\[OAcute]n \
se tiene en cuenta no solamente la correcci\[OAcute]n de las soluciones dadas \
sino tambi\[EAcute]n la claridad de las explicaciones, la \"eficacia\" de los \
comandos definidos (por ejemplo, los comandos que definas para hacer c\
\[AAcute]lculos num\[EAcute]ricos deben trabajar num\[EAcute]ricamente), el \
control de la precisi\[OAcute]n de los resultados obtenidos (cuando ello \
tenga sentido) y, en general, todo lo que hace que la soluci\[OAcute]n \
propuesta sea m\[AAcute]s o menos eficiente, sencilla y elegante.\nEn esta pr\
\[AAcute]ctica vamos a usar ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para calcular integrales de l\[IAcute]nea y funciones potenciales de \
campos conservativos."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integrales de l\[IAcute]nea y campos conservativos", "Section"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell["\<\
Define comandos que calculen simb\[OAcute]licamente integrales de \
l\[IAcute]nea de campos escalares de dos y tres variables. La sintaxis de \
estos comandos debe ser de la forma \"integlinea[f_,\[Gamma]_,a_,b_]\" donde \
debes suponer que \"f\" es el nombre de una funci\[OAcute]n conocida de dos o \
tres variables, \"\[Gamma]\" es el nombre de la funci\[OAcute]n que nos da el \
camino de integraci\[OAcute]n y que se integra en el intervalo [a,b].
Aqu\[IAcute] tienes un ejemplo de lo que debe ser capaz de hacer tu \
comando.\
\>", "ExerciseText"],

Cell[BoxData[
    \(\(\(f[x_, y_, z_] = x + y + z; \  (*\ 
      el\ campo\ escalar\ *) \n\[Gamma][t_] = {t, t, t\^2}; \  (*\ 
      el\ camino\ de\ integraci\[OAcute]n\ *) \n
    integlinea[f, \[Gamma], 0, 2]\)\( (*\ 
      este\ es\ el\ comando\ que\ t\[UAcute]\ debes\ definir\ y\ tiene\ que\ \
calcular\ simb\[OAcute]licamente\ la\ integral\ de\ l\[IAcute]nea\ del\ campo\
\ escalar\ f\ a\ lo\ largo\ del\ camino\ \[Gamma]\ para\ 0 \[LessEqual] 
        t \[LessEqual] 2\ *) \)\)\)], "Input"],

Cell[BoxData[{
    \(integlinea2[f_, \[Gamma]_, tmin_, tmax_] := 
      Integrate[
        f[\(\[Gamma][t]\)[\([1]\)], \(\[Gamma][
                t]\)[\([2]\)]]*\@\(\(\[Gamma]'\)[t] . \(\[Gamma]'\)[t]\), {t, 
          tmin, tmax}]\), "\[IndentingNewLine]", 
    \(integlinea[f_, \[Gamma]_, tmin_, tmax_] := 
      Integrate[
        f[\(\[Gamma][t]\)[\([1]\)], \(\[Gamma][t]\)[\([2]\)], \(\[Gamma][
                t]\)[\([3]\)]]*\@\(\(\[Gamma]'\)[t] . \(\[Gamma]'\)[t]\), {t, 
          tmin, tmax}]\)}], "Input"],

Cell[BoxData[{
    \(\(f[x_, y_, z_] = x + y + z;\)\), "\n", 
    \(\(\[Gamma][t_] = {t, t, t\^2};\)\), "\n", 
    \(integlinea[f, \[Gamma], 0, 2]\)}], "Input"],

Cell[TextData[{
  "Calcula las siguientes integrales de l\[IAcute]nea de los campos escalares \
",
  StyleBox["f",
    FontSlant->"Italic"],
  " sobre la curva \[Gamma].\na)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = x\ y\)]],
  " , ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((2  cos\ t, \ sen\ t)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] \[Pi]/2\)]],
  ".\nb)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = y/x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((\ t\^4, \ \ t\^3)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  ".\nc)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = y\ sen\ z\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((cos\ t, \ sen\ t, t)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ".\nd)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = x\ z\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((6\ t, \ \ 3 \(\@ 2\) t\^2, 
          2  t\^3)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell["\<\
Repite lo hecho en el ejercicio 1 para definir un comando \
\"integlineavector[f_,\[Gamma]_,a_,b_]\" que calcule simb\[OAcute]licamente \
integrales de l\[IAcute]nea de campos vectoriales de dos y tres variables.\
\>", "ExerciseText"],

Cell[TextData[{
  "Calcula las siguientes integrales de l\[IAcute]nea de los campos \
vectoriales ",
  StyleBox["f",
    FontSlant->"Italic"],
  " sobre la curva \[Gamma].\na)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = \((x, y, z)\)\)]],
  " , ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((cos\ t, \ sen\ t, t)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ".\nb)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = \((x, \(-y\), x\ y)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)]],
  " es el segmento de recta que une los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((2, 1, 3)\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-4\), 6, 8)\)\)]],
  ".\nc) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y, z)\), "=", 
          RowBox[{
            RowBox[{"y", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "-", 
            RowBox[{"x", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", " ", 
            StyleBox["k",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((cos\ t, \ sen\ t, t)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ".\nd)  ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y, z)\), "=", 
          RowBox[{
            RowBox[{"4", " ", "x", " ", \(\[ExponentialE]\^z\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"cos", " ", "y", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"2", \(x\^2\), \(\[ExponentialE]\^z\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](t)\), "=", " ", 
          RowBox[{
            RowBox[{"t", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(t\^2\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(t\^4\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  "."
}], "ExerciseText"],

Cell[BoxData[
    \(integlineavector[F_, \[Gamma]_, a_, b_] := 
      Integrate[
        F[\(\[Gamma][t]\)[\([1]\)], \(\[Gamma][t]\)[\([2]\)]] . \(\[Gamma]'\)[
            t], {t, a, b}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "a) Define un comando para aproximar la integral de l\[IAcute]nea ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_\[Gamma]\( f(x, 
            y)\) \[DifferentialD]s\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " es un campo escalar de dos variables y ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma] : \([a, 
            b]\) \[Rule] \[DoubleStruckCapitalR]\^2\)]],
  " es una curva en el plano que debes suponer conocidas. El comando debe \
tener la sintaxis \"aproxinteglinea[f_,\[Gamma]_,a_,b_,n_]\" y debe realizar \
las siguientes acciones:\n1. Dividir el intervalo [a,b] en n partes iguales \
por puntos ",
  Cell[BoxData[
      \(TraditionalForm\`t\_k = a + \(k(b - a)\)/n\)]],
  ". \n2. Calcular la suma ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(j = 1\)\%n f(\[Gamma](t\_j)) || \[Gamma](
            t\_\(j - 1\)) - \[Gamma](t\_j) || \)]],
  ".\nLos c\[AAcute]lculos deben realizarse num\[EAcute]ricamente. \nb) \
Calcula de forma exacta, usando el comando que has definido en el ejercicio \
1, el \[AAcute]rea de una cortina cuya base es la circunferencia",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\[Gamma](
          t) = \((1 + cos\ t, \ \ sen\ t)\)\)\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\(\(,\)\(\ \)\(0 \[LessEqual] t \[LessEqual] 
        2  \[Pi]\)\)\)]],
  " y cuya altura en cada punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " de la circunferencia viene dada por ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \(\(\@\(4 - x\^2 - y\^2\)\)\(.\)\)\)]],
  " Calcula, usando el comando que has definido en el apartado anterior, una \
aproximaci\[OAcute]n del valor obtenido con tres cifras decimales exactas. "
}], "ExerciseText"],

Cell[BoxData[
    \(aproxintlin[f_, \[Gamma]_, a_, b_, n_, p_:  17] := 
      Module[{inc, particion, adelante, \ atras, longitudes, valores, \ 
          h}, \[IndentingNewLine]inc = 
          N[\((b - a)\)/n, p]; \[IndentingNewLine]particion = 
          Range[N[a, p], N[b, p], inc]; \[IndentingNewLine]h[t_] := 
          f[\(\[Gamma][t]\)[\([1]\)], \(\[Gamma][
                t]\)[\([2]\)]]; \[IndentingNewLine]adelante = 
          Drop[particion, 1]; \[IndentingNewLine]atras = 
          Drop[particion, \(-1\)]; \[IndentingNewLine]longitudes = 
          N[Sqrt[Apply[
                Plus, \((Map[\[Gamma], adelante] - Map[\[Gamma], atras])\)^2, 
                1]], p]; \[IndentingNewLine]valores = 
          Map[h, adelante]; \[IndentingNewLine]Total[
          valores*longitudes]]\)], "Input"],

Cell[BoxData[{
    \(\(f[x_, y_] = \@\(4 - x\^2 - y\^2\);\)\), "\[IndentingNewLine]", 
    \(\(\[Gamma][t_] = {1 + Cos[t], \ \ Sin[t]};\)\), "\[IndentingNewLine]", 
    \(aproxintlin[f, \[Gamma], 0, 2  \[Pi], 200]\), "\[IndentingNewLine]", 
    \(integlinea2[f, \[Gamma], 0, 2  \[Pi]]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "a) Define un comando que te diga si un campo vectorial de dos variables es \
o no localmente conservativo. La sintaxis de dicho comando debe ser de la \
forma \"conservativoQ[Func]\" donde se supone que \"Func\" es el campo \
vectorial y su salida debe ser \"El campo es localmente conservativo\" o \"El \
campo no es localmente conservativo\". \nb) Haz lo mismo que en el apartado \
a) para campos vectoriales de tres variables.\nSugerencia. Para comprobar que \
dos funciones g[x,y], h[x,y]  son iguales es eficaz usar el comando ",
  Cell[BoxData[
      \(TraditionalForm\`Simplify[g[x, y] - h[x, y] == 0] === True\)]],
  ". El comando \"",
  Cell[BoxData[
      \(TraditionalForm\`exp1 === exp2\)]],
  "\" comprueba si las dos expresiones son ",
  StyleBox["id\[EAcute]nticas",
    FontSlant->"Italic"],
  ". La raz\[OAcute]n de esto puedes entenderla con el siguiente ejemplo."
}], "ExerciseText"],

Cell[BoxData[
    \(\(\(Simplify[x \((x + y)\) - x\^2 - x\ y == 0]\  (*\ salida\ True\ *) \n
    
    Simplify[x \((x + y)\) - x\^2 == 0] (*\ 
      salida\ que\ no\ es\ True\ y\ tampoco\ False\ *) \n
    Simplify[x \((x + y)\) - x\^2 == 0] === True\  (*\ salida\ False\ *) \n
    Simplify[x \((x + y)\) - x\^2 - x\ y == 0] === True\  (*\ 
      salida\ True\ *) \n
    Simplify[x \((x + y)\) - x\^2 - x\ y === 0]\)\(\ \)\( (*\ 
      salida\ False\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(conservativoQ[F_] := 
      If[Simplify[
            D[\(F[x, y]\)[\([1]\)], y] - D[\(F[x, y]\)[\([2]\)], x] == 0] === 
          True, Print["\<El campo es localmente conservativo\>"], 
        Print["\<El campo no es localmente conservativo\>"]]\)], "Input"],

Cell[BoxData[{
    \(\(F[x_, y_] = {6  y\  + \ y\ Exp[x\ y\ ] + 1, 
          6  x + x\ Exp[x\ y]};\)\), "\n", 
    \(conservativoQ[F]\)}], "Input"],

Cell[BoxData[{
    \(\(F[x_, y_] = {y\^2\ Exp[x\ y\ ], x\^2\ Exp[x\ y]};\)\), "\n", 
    \(conservativoQ[F]\)}], "Input"],

Cell[BoxData[
    \(conservativoQ[F_] := 
      If[Simplify[{D[\(F[x, y, z]\)[\([2]\)], z] - 
                  D[\(F[x, y, z]\)[\([3]\)], y], 
                D[\(F[x, y, z]\)[\([3]\)], x] - 
                  D[\(F[x, y, z]\)[\([1]\)], z], 
                D[\(F[x, y, z]\)[\([1]\)], y] - 
                  D[\(F[x, y, z]\)[\([2]\)], x]} == {0, 0, 0}] === True, 
        Print["\<El campo es localmente conservativo\>"], 
        Print["\<El campo no es localmente conservativo\>"]]\)], "Input"],

Cell[BoxData[{
    \(\(F[x_, y_, 
          z_] = \(1\/\@\((x\^2 + y\^2 + z\^2)\)\^3\) {x, y, z};\)\), "\n", 
    \(conservativoQ[F]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "Indica si los siguiente campos son localmente conservativos. \
\[DownQuestion]Son conservativos en todo su dominio de definici\[OAcute]n?\n\
a) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y)\), "=", 
          RowBox[{\(Exp[x]\), 
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(Cos[y]\), " ", 
                  StyleBox["i",
                    FontWeight->"Bold"]}], " ", "-", " ", 
                RowBox[{\(Sin[y]\), " ", 
                  StyleBox["j",
                    FontWeight->"Bold"]}]}], ")"}]}]}], TraditionalForm]]],
  ".\nb) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y)\), "=", 
          RowBox[{
            RowBox[{\(y\^2\), " ", \(Exp[x\ y]\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(x\^2\), \(Exp[x\ y]\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ".\nc) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y)\), "=", 
          RowBox[{
            RowBox[{\((6  y + y\ Exp[x\ y] + 1)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\((6  x + x\ Exp[x\ y])\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ".\nd) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y, z)\), "=", 
          RowBox[{
            RowBox[{\(y\^2\), \(z\^3\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"2", " ", "x", " ", "y", " ", \(z\^3\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"3", "x", " ", \(y\^2\), \(z\^2\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ".\ne) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x, y, z)\), "=", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{"x", " ", 
                  StyleBox["i",
                    FontWeight->"Bold"]}], " ", "+", " ", 
                RowBox[{"y", " ", 
                  StyleBox["j",
                    FontWeight->"Bold"]}], " ", "+", " ", 
                RowBox[{"z", " ", 
                  StyleBox["k",
                    FontWeight->"Bold"]}]}], ")"}], 
            "/", \(\@\(x\^2 + y\^2 + z\^2\)\)}]}], TraditionalForm]]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell[TextData[{
  "a) Define un comando que calcule simb\[OAcute]licamente la funci\[OAcute]n \
potencial que se anula en el origen de un campo vectorial de dos variables. \
La sintaxis del comando debe ser de la forma \"potencial[F][x,y]\" donde \
\"F\" es el campo. \nSugerencia. Un comando If[ ] es suficiente. Debes \
controlar si el campo es conservativo.\nb) Calcula con el comando que has \
definido potenciales de los campos siguientes:\nb1)",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(F(x, y) = \((y, x)\)\)\)\)]],
  "\nb2) ",
  Cell[BoxData[
      \(TraditionalForm\`F(x, y) = \((3 + 2  x\ y, x\^2 - 3  y\^2)\)\)]],
  "\nb3) ",
  Cell[BoxData[
      \(TraditionalForm\`F(x, 
          y) = \((2  x\ sen\ y, \(x\^2\) cos\ y - 3  y\^2)\)\)]],
  "\nb4) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(F(x, y)\), "=", 
          RowBox[{
            RowBox[{\((2  y\^2 - 12 \( x\^3\) y\^3)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\((4  x\ y\  - \ 9 \( x\^4\) y\^2)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  "\nb5) ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(F(x, y)\), "=", 
          RowBox[{
            RowBox[{\((\(y\^2\) cos\ x + 2  x\ \[ExponentialE]\^y)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\((2  y\ sen\ x\  + \ x\^2\ \[ExponentialE]\^y)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]]
}], "ExerciseText"],

Cell[BoxData[
    \(\(potencial[F_]\)[x_, y_] := 
      Module[{g, u, v}, 
        If[Simplify[
              D[\(F[u, v]\)[\([1]\)], v] - D[\(F[u, v]\)[\([2]\)], u] == 0] === 
            False, Print["\<El campo no es localmente conservativo\>"], \n\
\((Integrate[\(F[u, v]\)[\([1]\)], {u, 0, x}] + 
                  g[v] /. \(DSolve[{\(g'\)[v] == \(F[0, v]\)[\([2]\)], 
                      g[0] == 0}, g[v], v]\)[\([1]\)])\) /. 
            v -> y\n\t]]\)], "Input"],

Cell[BoxData[
    \(\(potencial[F_]\)[x_, y_] := 
      Module[{u, v}, 
        If[Simplify[
              D[\(F[u, v]\)[\([1]\)], v] - D[\(F[u, v]\)[\([2]\)], u] == 0] === 
            False, Print["\<El campo no es localmente conservativo\>"], \n
          Integrate[\(F[u, y]\)[\([1]\)], {u, 0, x}] + 
            Integrate[\(F[0, v]\)[\([2]\)], {v, 0, y}]\n\t]]\)], "Input"],

Cell[BoxData[{
    \(\(F[x_, y_] = {y, x};\)\), "\n", 
    \(\(potencial[F]\)[x, y]\)}], "Input"],

Cell[BoxData[{
    \(\(F[x_, y_] = {3 + 2  x\ y, x\^2 - 3  y\^2};\)\), "\n", 
    \(\(potencial[F]\)[x, y]\)}], "Input"],

Cell[BoxData[{
    \(\(F[x_, y_] = {2  x\ Sin[y], \(x\^2\) Cos[y] - 3  y\^2};\)\), "\n", 
    \(\(potencial[F]\)[x, y]\)}], "Input"],

Cell[BoxData[{
    \(\(F[x_, y_] = {2  y\^2 - 12 \( x\^3\) y\^3, 
          4  x\ y\  - \ 9 \( x\^4\) y\^2};\)\), "\n", 
    \(\(potencial[F]\)[x, y]\)}], "Input"],

Cell[BoxData[
    \(\(potencial[F_]\)[x_, y_, z_] := 
      Module[{u, v, w}, 
        If[Simplify[{D[\(F[x, y, z]\)[\([2]\)], z] - 
                    D[\(F[x, y, z]\)[\([3]\)], y], 
                  D[\(F[x, y, z]\)[\([3]\)], x] - 
                    D[\(F[x, y, z]\)[\([1]\)], z], 
                  D[\(F[x, y, z]\)[\([1]\)], y] - 
                    D[\(F[x, y, z]\)[\([2]\)], x]} == {0, 0, 0}] === False, 
          Print["\<El campo no es localmente conservativo\>"], \
\[IndentingNewLine]Integrate[\(F[u, y, z]\)[\([1]\)], {u, 0, x}] + 
            Integrate[\(F[0, v, z]\)[\([2]\)], {v, 0, y}] + 
            Integrate[\(F[0, 0, w]\)[\([3]\)], {w, 0, 
                z}]\[IndentingNewLine]]]\)], "Input"],

Cell[BoxData[{
    \(F[x_, y_, z_] = {y, \ x + z\ Cos[y\ z], \ 
        y\ Cos[y\ z]}\), "\[IndentingNewLine]", 
    \(\(potencial[F]\)[x, y, z]\)}], "Input"],

Cell[BoxData[
    \(numericinteglinvector[F_, \[Gamma]_, a_, b_] := 
      NIntegrate[
        F[\(\[Gamma][t]\)[\([1]\)], \(\[Gamma][t]\)[\([2]\)]] . \(\[Gamma]'\)[
            t], {t, a, b}]\)], "Input"],

Cell[BoxData[{
    \(\(F[x_, y_] = {3  y - Exp[Sin[x]], 
          7  x + \@\(y\^4 + 1\)};\)\), "\[IndentingNewLine]", 
    \(\(\[Gamma][t_] = {3\ Cos[t], 3\ Sin[t]};\)\), "\[IndentingNewLine]", 
    \(numericinteglinvector[F, \[Gamma], 0, 
      2  \[Pi]]\), "\[IndentingNewLine]", 
    \(Integrate[\(D[F[x, y], y]\)[\([1]\)] - \(D[F[x, y], 
            x]\)[\([2]\)], {x, \(-3\), 
        3}, {y, \(-\@\(9 - x\^2\)\), \@\(9 - x\^2\)}]\)}], "Input"],

Cell[BoxData[{
    \(\(\(segmento[j_]\)[t_] := \((1 - t)\)*puntos[\([j]\)] + 
          t*puntos[\([j + 1]\)];\)\), "\[IndentingNewLine]", 
    \(\(\(x[j_]\)[
          t_] := \(\(segmento[j]\)[
            t]\)[\([1]\)];\)\), "\[IndentingNewLine]", 
    \(\(\(y[j_]\)[
          t_] := \(\(segmento[j]\)[
            t]\)[\([2]\)];\)\), "\[IndentingNewLine]", 
    \(Sum[
        Integrate[\(x[j]\)[t]*\(y[j]'\)[t] - \(y[j]\)[t]*\(x[j]'\)[t], {t, 0, 
            1}], {j, 1, Length[puntos] - 1}]* .5\)}], "Input"],

Cell[BoxData[
    \(s := Random[Integer, {100, 200}]\)], "Input"],

Cell[BoxData[
    \(Union[Table[{a = s, N[E] - N[\((1 + 1/a)\)^a]}, {100}]]\)], "Input"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 635},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, 2},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Integrales de l\[IAcute]nea. Campos conservativos"], 
        "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Integrales de l\[IAcute]nea. Campos conservativos"], 
        "Header"]}},
PrintingOptions->{"FirstPageHeader"->False,
"FacingPages"->True},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 66, 0, 99, "Title"],
Cell[1823, 53, 189, 7, 130, "Author"],

Cell[CellGroupData[{
Cell[2037, 64, 39, 0, 93, "Section"],
Cell[2079, 66, 1739, 28, 325, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3855, 99, 69, 0, 93, "Section"],

Cell[CellGroupData[{
Cell[3949, 103, 31, 0, 68, "Exercise"],
Cell[3983, 105, 563, 9, 153, "ExerciseText"],
Cell[4549, 116, 496, 8, 202, "Input"],
Cell[5048, 126, 516, 10, 167, "Input"],
Cell[5567, 138, 160, 3, 124, "Input"],
Cell[5730, 143, 1273, 43, 177, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7040, 191, 31, 0, 68, "Exercise"],
Cell[7074, 193, 244, 4, 67, "ExerciseText"],
Cell[7321, 199, 2436, 77, 177, "ExerciseText"],
Cell[9760, 278, 199, 4, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9996, 287, 31, 0, 68, "Exercise"],
Cell[10030, 289, 1762, 39, 313, "ExerciseText"],
Cell[11795, 330, 811, 14, 332, "Input"],
Cell[12609, 346, 298, 4, 164, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12944, 355, 31, 0, 68, "Exercise"],
Cell[12978, 357, 921, 17, 213, "ExerciseText"],
Cell[13902, 376, 470, 9, 203, "Input"],
Cell[14375, 387, 280, 5, 150, "Input"],
Cell[14658, 394, 148, 3, 98, "Input"],
Cell[14809, 399, 121, 2, 99, "Input"],
Cell[14933, 403, 498, 9, 228, "Input"],
Cell[15434, 414, 146, 3, 144, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15617, 422, 31, 0, 68, "Exercise"],
Cell[15651, 424, 2426, 70, 211, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18114, 499, 31, 0, 68, "Exercise"],
Cell[18148, 501, 1558, 38, 305, "ExerciseText"],
Cell[19709, 541, 472, 9, 228, "Input"],
Cell[20184, 552, 378, 7, 202, "Input"],
Cell[20565, 561, 97, 2, 98, "Input"],
Cell[20665, 565, 120, 2, 99, "Input"],
Cell[20788, 569, 132, 2, 99, "Input"],
Cell[20923, 573, 163, 3, 99, "Input"],
Cell[21089, 578, 718, 13, 306, "Input"],
Cell[21810, 593, 158, 3, 98, "Input"],
Cell[21971, 598, 205, 4, 98, "Input"],
Cell[22179, 604, 450, 8, 208, "Input"],
Cell[22632, 614, 514, 11, 176, "Input"],
Cell[23149, 627, 65, 1, 72, "Input"],
Cell[23217, 630, 88, 1, 72, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

